% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program ThreeCLUT.m
figure;                   % set up a new figure window
image(M);            % display an image described in matrix M
axis('square');    % make the aspect ratio of the image 
                                % square
axis('off');       % turn off all axis lines and markings
lut1 = [0 0 0;  1 1 1]; % define a two row lookup table for 
                        % the color translation of 1,2
colormap(lut1);    % apply the lut to the displayed image
keyboard;          % stops execution of the program and 
                   % gives control to the user's keyboard 
                   % type "return" at the "K>>" prompt, 
                   % the program will continue
lut2 = [1 0 0;  0 1 0];  % a new lookup table
colormap(lut2);
keyboard;
lut3 = [0.6 0.6 0.6;  0.4 0.4 0.4]; %another lookup table
colormap(lut3);
